/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.utils.builder;

import ch.icit.utils.GTINCategory;

public class BarcodeBuilderEAN13 {
    public String createBarcodeWithoutCategoryWithChecksum(String customerCode, String content) {
        StringBuilder str = new StringBuilder();
        str.append(customerCode);
        str.append(content);
        str.append(this.checkSumEAN13(str.toString()));
        return str.toString();
    }

    public String readBarcodeContentOfEAN13(String barcode) {
        String usedBarcode = barcode;
        while (usedBarcode.length() < 13) {
            usedBarcode = "0" + usedBarcode;
        }
        String barcodeText = usedBarcode.substring(usedBarcode.length() - 9, usedBarcode.length() - 1);
        return barcodeText;
    }

    public Integer readBarcodeContentOfEAN13AsInteger(String barcode) {
        String barcodeText = this.readBarcodeContentOfEAN13(barcode);
        try {
            int intValue = Integer.parseInt(barcodeText);
            return intValue;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public GTINCategory readBarcodeCategoryOfEAN13(String barcode) {
        String usedBarcode = barcode;
        while (usedBarcode.length() < 13) {
            usedBarcode = "0" + usedBarcode;
        }
        String categoryId = usedBarcode.substring(usedBarcode.length() - 11, usedBarcode.length() - 9);
        for (GTINCategory value : GTINCategory.values()) {
            if (!value.getId().equals(categoryId)) continue;
            return value;
        }
        throw new IllegalStateException("Unknown Barcode");
    }

    public String readBarcodeCompanyOfEAN13(String barcode) {
        String usedBarcode = barcode;
        while (usedBarcode.length() < 13) {
            usedBarcode = "0" + usedBarcode;
        }
        String companyId = usedBarcode.substring(usedBarcode.length() - 13, usedBarcode.length() - 11);
        return companyId;
    }

    public String createEAN13Barcode(String barcodeText, GTINCategory category, String company, boolean silent) {
        if (company.length() > 2) {
            if (silent) {
                return null;
            }
            throw new IllegalStateException("Barcode is broken");
        }
        if (barcodeText.length() > 8) {
            if (silent) {
                return null;
            }
            throw new IllegalStateException("Barcode is too long");
        }
        String usedCompanyCode = company;
        while (usedCompanyCode.length() < 2) {
            usedCompanyCode = "0" + usedCompanyCode;
        }
        String usedBarcodeText = barcodeText;
        while (usedBarcodeText.length() < 8) {
            usedBarcodeText = "0" + usedBarcodeText;
        }
        return usedCompanyCode + category.getId() + usedBarcodeText;
    }

    public String createEAN13BarcodeWithChecksum(String barcodeText, GTINCategory category, String company, boolean silent) {
        String ean13Barcode = this.createEAN13Barcode(barcodeText, category, company, silent);
        int checkSumEAN13 = this.checkSumEAN13(ean13Barcode);
        ean13Barcode = ean13Barcode + checkSumEAN13;
        return ean13Barcode;
    }

    private int checkSumEAN13(String code) {
        int val = 0;
        for (int i = 0; i < code.length(); ++i) {
            val += Integer.parseInt(code.charAt(i) + "") * (i % 2 == 0 ? 1 : 3);
        }
        int checksum_digit = 10 - val % 10;
        if (checksum_digit == 10) {
            checksum_digit = 0;
        }
        return checksum_digit;
    }

    public void validateBarcode(String barcode, GTINCategory expectedCategory, String expectedCompany, boolean silent) {
        String companyId;
        if (!this.validateBarcodeNotNull(barcode, silent)) {
            return;
        }
        String usedBarcode = barcode;
        while (usedBarcode.length() < 13) {
            usedBarcode = "0" + usedBarcode;
        }
        String barcodeText = usedBarcode.substring(usedBarcode.length() - 9, usedBarcode.length() - 1);
        String categoryId = usedBarcode.substring(usedBarcode.length() - 11, usedBarcode.length() - 9);
        if (!this.validateCategoryAndCompany(expectedCategory, expectedCompany, silent, categoryId, companyId = usedBarcode.substring(usedBarcode.length() - 13, usedBarcode.length() - 11))) {
            return;
        }
    }

    private boolean validateBarcodeNotNull(String barcode, boolean silent) {
        if (barcode == null || barcode.isEmpty()) {
            if (silent) {
                return false;
            }
            throw new IllegalStateException("Barcode is empty");
        }
        return true;
    }

    private boolean validateCategoryAndCompany(GTINCategory category, String companyCode, boolean silent, String categoryId, String companyId) {
        if (!category.getId().equals(categoryId)) {
            if (silent) {
                return false;
            }
            throw new IllegalStateException("It's not a " + category.getName() + " Barcode");
        }
        if (!companyId.equals(companyCode)) {
            if (silent) {
                return false;
            }
            throw new IllegalStateException("Third party Barcode scanned");
        }
        return true;
    }
}

