/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.utils.sftp;

import ch.icit.utils.FtpClientConfiguration;
import ch.icit.utils.FtpClientException;
import ch.icit.utils.FtpErrorCode;
import ch.icit.utils.Tuple;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpClient {
    private static final Logger log = LoggerFactory.getLogger(SftpClient.class);

    private static Session initSession(FtpClientConfiguration config, JSch jsch) throws JSchException {
        if (config.isUseKeyAuth()) {
            jsch.addIdentity(config.getLocalPrivateKeyPath());
        }
        Session session = jsch.getSession(config.getUser(), config.getUrl(), config.getPort());
        session.setConfig("StrictHostKeyChecking", "no");
        session.setPassword(config.getPassword());
        session.connect();
        return session;
    }

    private static ChannelSftp initChannel(Session session) throws JSchException {
        Channel channel = session.openChannel("sftp");
        channel.connect();
        ChannelSftp sftpChannel = (ChannelSftp)channel;
        return sftpChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existsRemoteFileName(FtpClientConfiguration config, String directory) throws FtpClientException {
        JSch jsch = new JSch();
        Session session = null;
        ChannelSftp sftpChannel = null;
        try {
            session = SftpClient.initSession(config, jsch);
            sftpChannel = SftpClient.initChannel(session);
            String path = config.getFolder();
            SftpATTRS lstat = sftpChannel.lstat(path);
            if (lstat == null) {
                boolean bl = false;
                return bl;
            }
            SftpClient.changeDirectoryPath(sftpChannel, path);
            SftpATTRS fileExists = sftpChannel.lstat(directory);
            if (fileExists != null) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (JSchException e) {
            boolean bl = false;
            return bl;
        }
        catch (SftpException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (sftpChannel != null) {
                sftpChannel.exit();
            }
            if (session != null) {
                session.disconnect();
            }
        }
    }

    public static List<ChannelSftp.LsEntry> getRemoteFileNames(FtpClientConfiguration config) throws FtpClientException {
        JSch jsch = new JSch();
        Session session = null;
        ChannelSftp sftpChannel = null;
        try {
            session = SftpClient.initSession(config, jsch);
            sftpChannel = SftpClient.initChannel(session);
            String path = config.getFolder();
            SftpClient.changeDirectoryPath(sftpChannel, path);
            ArrayList<ChannelSftp.LsEntry> remoteFileList = new ArrayList<ChannelSftp.LsEntry>();
            Vector files = sftpChannel.ls(".");
            for (Object e : files) {
                ChannelSftp.LsEntry f = (ChannelSftp.LsEntry)e;
                remoteFileList.add(f);
            }
            ArrayList<ChannelSftp.LsEntry> arrayList = remoteFileList;
            return arrayList;
        }
        catch (JSchException e) {
            throw new FtpClientException(1000, FtpErrorCode.JSchException, e.getMessage(), e);
        }
        catch (SftpException e) {
            throw new FtpClientException(2000, FtpErrorCode.SftpException, e.getMessage(), e);
        }
        finally {
            if (sftpChannel != null) {
                sftpChannel.exit();
            }
            if (session != null) {
                session.disconnect();
            }
        }
    }

    public static Map<String, File> readFiles(FtpClientConfiguration config, Map<String, File> fileList) throws FtpClientException {
        if (fileList == null || fileList.isEmpty()) {
            return fileList;
        }
        JSch jsch = new JSch();
        Session session = null;
        ChannelSftp sftpChannel = null;
        try {
            session = SftpClient.initSession(config, jsch);
            sftpChannel = SftpClient.initChannel(session);
            String path = config.getFolder();
            SftpClient.changeDirectoryPath(sftpChannel, path);
            for (Map.Entry<String, File> f : fileList.entrySet()) {
                File dir = new File(f.getValue().getAbsolutePath().substring(0, f.getValue().getAbsolutePath().lastIndexOf(File.separator)));
                if (!dir.exists() || !dir.isDirectory()) {
                    dir.mkdirs();
                }
                sftpChannel.get(f.getKey(), f.getValue().getAbsolutePath());
            }
            Map<String, File> map = fileList;
            return map;
        }
        catch (JSchException e) {
            throw new FtpClientException(1000, FtpErrorCode.JSchException, e.getMessage(), e);
        }
        catch (SftpException e) {
            throw new FtpClientException(2000, FtpErrorCode.SftpException, e.getMessage(), e);
        }
        finally {
            if (sftpChannel != null) {
                sftpChannel.exit();
            }
            if (session != null) {
                session.disconnect();
            }
        }
    }

    public static void sendFiles(FtpClientConfiguration config, Map<File, String> fileList) throws FtpClientException {
        FileInputStream fileInputStream = null;
        if (fileList == null || fileList.isEmpty()) {
            return;
        }
        JSch jsch = new JSch();
        Session session = null;
        ChannelSftp sftpChannel = null;
        try {
            session = SftpClient.initSession(config, jsch);
            sftpChannel = SftpClient.initChannel(session);
            String path = config.getFolder();
            SftpClient.changeDirectoryPath(sftpChannel, path);
            for (Map.Entry<File, String> file : fileList.entrySet()) {
                fileInputStream = new FileInputStream(file.getKey());
                sftpChannel.put((InputStream)fileInputStream, file.getValue(), 0);
                fileInputStream.close();
            }
        }
        catch (JSchException e) {
            throw new FtpClientException(1000, FtpErrorCode.JSchException, e.getMessage(), e);
        }
        catch (SftpException e) {
            throw new FtpClientException(2000, FtpErrorCode.SftpException, e.getMessage(), e);
        }
        catch (FileNotFoundException e) {
            throw new FtpClientException(3000, FtpErrorCode.FileNotFoundException, e.getMessage(), e);
        }
        catch (IOException e) {
            throw new FtpClientException(4000, FtpErrorCode.IOException, e.getMessage(), e);
        }
        finally {
            if (sftpChannel != null) {
                sftpChannel.exit();
            }
            if (session != null) {
                session.disconnect();
            }
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void deleteFiles(FtpClientConfiguration config, List<String> fileList) throws FtpClientException {
        if (fileList == null || fileList.isEmpty()) {
            return;
        }
        JSch jsch = new JSch();
        Session session = null;
        ChannelSftp sftpChannel = null;
        try {
            session = SftpClient.initSession(config, jsch);
            sftpChannel = SftpClient.initChannel(session);
            String path = config.getFolder();
            SftpClient.changeDirectoryPath(sftpChannel, path);
            for (String file : fileList) {
                sftpChannel.rm(file);
            }
        }
        catch (JSchException e) {
            throw new FtpClientException(1000, FtpErrorCode.JSchException, e.getMessage(), e);
        }
        catch (SftpException e) {
            throw new FtpClientException(2000, FtpErrorCode.SftpException, e.getMessage(), e);
        }
        finally {
            if (sftpChannel != null) {
                sftpChannel.exit();
            }
            if (session != null) {
                session.disconnect();
            }
        }
    }

    public static void deleteFiles(FtpClientConfiguration config, Map<ChannelSftp.LsEntry, Tuple<Timestamp, String>> fileList) throws FtpClientException {
        if (fileList == null || fileList.isEmpty()) {
            return;
        }
        JSch jsch = new JSch();
        Session session = null;
        ChannelSftp sftpChannel = null;
        try {
            session = SftpClient.initSession(config, jsch);
            sftpChannel = SftpClient.initChannel(session);
            String path = config.getFolder();
            SftpClient.changeDirectoryPath(sftpChannel, path);
            for (Map.Entry<ChannelSftp.LsEntry, Tuple<Timestamp, String>> file : fileList.entrySet()) {
                sftpChannel.rm(file.getKey().getFilename());
            }
        }
        catch (JSchException e) {
            throw new FtpClientException(1000, FtpErrorCode.JSchException, e.getMessage(), e);
        }
        catch (SftpException e) {
            throw new FtpClientException(2000, FtpErrorCode.SftpException, e.getMessage(), e);
        }
        finally {
            if (sftpChannel != null) {
                sftpChannel.exit();
            }
            if (session != null) {
                session.disconnect();
            }
        }
    }

    public static void moveParsedFilesIntoBackupFolder(FtpClientConfiguration config, List<Tuple<String, Date>> fileList, String destinationDirectory) throws FtpClientException {
        if (fileList == null || fileList.isEmpty()) {
            return;
        }
        JSch jsch = new JSch();
        Session session = null;
        ChannelSftp sftpChannel = null;
        try {
            session = SftpClient.initSession(config, jsch);
            sftpChannel = SftpClient.initChannel(session);
            String path = config.getFolder();
            SftpClient.changeDirectoryPath(sftpChannel, path);
            ArrayList<Date> dateList = new ArrayList<Date>();
            for (Tuple<String, Date> originFile : fileList) {
                if (originFile.getT() != null && !dateList.contains(originFile.getT())) {
                    dateList.add(originFile.getT());
                    System.out.println("date" + originFile.getT());
                    SftpClient.existsDirectory(sftpChannel, destinationDirectory, SftpClient.getMonthOrYear(originFile.getT(), 1, 0), SftpClient.getMonthOrYear(originFile.getT(), 2, 1));
                }
                String destinationFile = destinationDirectory + "/" + SftpClient.getMonthOrYear(originFile.getT(), 1, 0) + "/" + SftpClient.getMonthOrYear(originFile.getT(), 2, 1) + "/" + originFile.getS();
                sftpChannel.rename(originFile.getS(), destinationFile);
            }
        }
        catch (JSchException e) {
            throw new FtpClientException(1000, FtpErrorCode.JSchException, e.getMessage(), e);
        }
        catch (SftpException e) {
            throw new FtpClientException(2000, FtpErrorCode.SftpException, e.getMessage(), e);
        }
        finally {
            if (sftpChannel != null) {
                sftpChannel.exit();
            }
            if (session != null) {
                session.disconnect();
            }
        }
    }

    private static boolean existsDirectory(ChannelSftp sftpChannel, String directory) {
        try {
            SftpATTRS lstat = sftpChannel.lstat(directory);
            return true;
        }
        catch (SftpException e) {
            return false;
        }
    }

    private static void existsDirectory(ChannelSftp sftpChannel, String directory, String year, String month) {
        SftpATTRS ex2;
        try {
            SftpATTRS sftpATTRS = sftpChannel.lstat(directory);
        }
        catch (SftpException ex2) {
            try {
                sftpChannel.mkdir(directory);
            }
            catch (SftpException sftpException) {
                // empty catch block
            }
        }
        try {
            sftpChannel.cd(directory);
            ex2 = sftpChannel.lstat(year);
        }
        catch (SftpException ex3) {
            try {
                sftpChannel.mkdir(year);
            }
            catch (SftpException sftpException) {
                // empty catch block
            }
        }
        try {
            sftpChannel.cd(String.valueOf(year));
            ex2 = sftpChannel.lstat(month);
        }
        catch (SftpException ex4) {
            try {
                sftpChannel.mkdir(month);
            }
            catch (SftpException sftpException) {
                // empty catch block
            }
        }
        try {
            sftpChannel.cd("..");
            sftpChannel.cd("..");
        }
        catch (SftpException sftpException) {
            // empty catch block
        }
    }

    private static void changeDirectoryPath(ChannelSftp sftpChannel, String path) {
        log.debug("00: changeDirectoryPath OK:" + File.separator + "|" + path);
        String[] folders = path.split("\\\\");
        String[] folders2 = path.split("/");
        if (folders2.length > folders.length) {
            folders = folders2;
        }
        for (String folder : folders) {
            if (folder.length() <= 0) continue;
            try {
                sftpChannel.cd(folder);
                log.debug("11: changeDirectoryPath OK");
            }
            catch (SftpException e) {
                try {
                    sftpChannel.mkdir(folder);
                    sftpChannel.cd(folder);
                    log.debug("22: changeDirectoryPath OK");
                }
                catch (SftpException e2) {
                    log.debug("33:changeDirectoryPath not OK");
                }
            }
        }
    }

    private static String getMonthOrYear(Date date, int calendarType, int addition) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int i = cal.get(calendarType) + addition;
        if (i < 10) {
            return "0" + i;
        }
        return "" + i;
    }
}

