/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.util;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFRenderer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.PageRanges;

public class PDFPrinter
implements Printable {
    PDFFile pdfFile;

    public void doPrint(String file, PrintService printer, boolean portrait, boolean withPrintDialog, int copies) throws Exception {
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            HashPrintRequestAttributeSet attset;
            PrinterJob job;
            block22: {
                FileChannel fc = raf.getChannel();
                MappedByteBuffer buf = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
                this.pdfFile = new PDFFile((ByteBuffer)buf);
                job = PrinterJob.getPrinterJob();
                PageFormat format = job.defaultPage();
                if (portrait) {
                    format.setOrientation(1);
                } else {
                    format.setOrientation(0);
                }
                Paper temp = format.getPaper();
                temp.setImageableArea(-15.0, 0.0, temp.getWidth() + 30.0, temp.getHeight());
                format.setPaper(temp);
                attset = new HashPrintRequestAttributeSet();
                attset.add(new PageRanges(1, this.pdfFile.getNumPages()));
                attset.add(new Copies(copies));
                if (format != null) {
                    job.setPrintable(this, format);
                }
                if (printer != null) {
                    job.setPrintService(printer);
                }
                if (!withPrintDialog || job.printDialog(attset)) break block22;
                return;
            }
            try {
                job.print(attset);
            }
            catch (PrinterException pe) {
                pe.printStackTrace();
            }
        }
    }

    @Override
    public int print(Graphics g, PageFormat format, int index) throws PrinterException {
        int pagenum = index + 1;
        if (pagenum < 1 || pagenum > this.pdfFile.getNumPages()) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        AffineTransform at = g2d.getTransform();
        PDFPage pdfPage = this.pdfFile.getPage(pagenum);
        Dimension dim = pdfPage.getUnstretchedSize((int)format.getImageableWidth(), (int)format.getImageableHeight(), pdfPage.getBBox());
        Rectangle bounds = new Rectangle((int)format.getImageableX(), (int)format.getImageableY(), dim.width, dim.height);
        PDFRenderer rend = new PDFRenderer(pdfPage, (Graphics2D)g, bounds, null, null);
        try {
            pdfPage.waitForFinish();
            rend.run();
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
        g2d.setTransform(at);
        g2d.draw(new Rectangle2D.Double(format.getImageableX(), format.getImageableY(), format.getImageableWidth(), format.getImageableHeight()));
        return 0;
    }
}

